/*
** ###################################################################
**     This code is generated by the Device Initialization Tool.
**     It is overwritten during code generation.
**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES 
**                                                 OR EXPLICITLY MARKED SECTIONS
**
**     Project   : QE8_Low_Power
**     Processor : MC9S08QE8_TSSOP16
**     Version   : Bean 01.001, Driver 01.04, CPU db: 3.00.002
**     Datasheet : MC9S08QE8RM Rev. 1 3/2007
**     Date/Time : 29.11.2007, 17:09
**     Abstract  :
**         This module contains device initialization code 
**         for selected on-chip peripherals.
**     Contents  :
**         Function "MCU_init" initializes selected peripherals
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2006
**     UNIS, spol s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################
*/

/* MODULE MCUinit */

#include <MC9S08QE8.h>                 /* I/O map for MC9S08QE8_TSSOP16 */
#include "MCUinit.h"

/* User declarations and definitions */
/*   Code, declarations and definitions here will be preserved during code generation */
/* End of user declarations and definitions */


/*
** ===================================================================
**     Method      :  MCU_init (bean MC9S08QE8_16)
**
**     Description :
**         Device initialization code for selected peripherals.
** ===================================================================
*/
void MCU_init(void)
{
  /* ### MC9S08QE8_16 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /* Common initialization of the write once registers */
  /* SOPT1: COPE=1,COPT=1,STOPE=1,BKGDPE=1,RSTPE=0 */
  SOPT1 = 0xE2;                                      
  /* SOPT2: COPCLKS=0,TPM2CH2PS=0,TPM1CH2PS=0,ACIC2=0,IICPS=0,ACIC1=0 */
  SOPT2 = 0x00;                                      
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=0,BGBE=0 */
  SPMSC1 = 0x18;                                      
  /* SPMSC2: LPR=0,LPRS=0,LPWUI=0,PPDF=0,PPDACK=0,PPDE=0,PPDC=0 */
  SPMSC2 = 0x00;                                      
  /* SPMSC3: LVWIE=0 */
  SPMSC3 &= (unsigned char)~0x08;                     
  /*  System clock initialization */
  ICSTRM = *(unsigned char*far)0xFFAF; /* Initialize ICSTRM register from a non volatile memory */
  ICSSC = *(unsigned char*far)0xFFAE;  /* Initialize ICSSC register from a non volatile memory */
  /* ICSC1: CLKS=0,RDIV=0,IREFS=1,IRCLKEN=1,IREFSTEN=1 */
  ICSC1 = 0x07;                        /* Initialization of the ICS control register 1 */
  /* ICSC2: BDIV=0,RANGE=0,HGO=0,LP=0,EREFS=0,ERCLKEN=0,EREFSTEN=0 */
  ICSC2 = 0x00;                        /* Initialization of the ICS control register 2 */
  while(!ICSSC_IREFST) {               /* Wait until the source of reference clock is internal clock */
   {asm sta SRS;}                      /* Reset watchdog counter */
  }
  /* ICSSC: DRST_DRS=0,DMX32=0 */
  ICSSC &= (unsigned char)~0xE0;       /* Initialization of the ICS status and control */
  /* Common initialization of the CPU registers */
  /* SCGC1: TPM2=0,TPM1=0,ADC=0,IIC=1,SCI=1 */
  SCGC1 = (SCGC1 & (unsigned char)~0x70) | (unsigned char)0x05;
  /* SCGC2: DBG=0,FLS=0,IRQ=0,KBI=1,ACMP=0,RTC=0,SPI=1 */
  SCGC2 = (SCGC2 & (unsigned char)~0xEC) | (unsigned char)0x11;
  /* PTAPE: PTAPE1=1 */
  PTAPE |= (unsigned char)0x02;                               
  /* PTBPE: PTBPE0=1 */
  PTBPE |= (unsigned char)0x01;                               
  /* PTASE: PTASE4=0,PTASE3=0,PTASE2=0,PTASE1=0,PTASE0=0 */
  PTASE &= (unsigned char)~0x1F;                     
  /* PTBSE: PTBSE7=0,PTBSE6=0,PTBSE5=0,PTBSE4=0,PTBSE3=0,PTBSE2=0,PTBSE1=0,PTBSE0=0 */
  PTBSE = 0x00;                                      
  /* PTADS: PTADS7=0,PTADS6=0,PTADS5=0,PTADS4=0,PTADS3=0,PTADS2=0,PTADS1=0,PTADS0=0 */
  PTADS = 0x00;                                      
  /* PTBDS: PTBDS7=1,PTBDS6=0,PTBDS5=0,PTBDS4=0,PTBDS3=0,PTBDS2=0,PTBDS1=0,PTBDS0=0 */
  PTBDS = 0x80;                                      
  /* ### Init_GPIO init code */
  /* PTAPE: PTAPE5=1 */
  PTAPE |= (unsigned char)0x20;                               
  /* ### Init_COP init code */
  SRS = 0xFF;                          /* Clear WatchDog counter */
  /* ### Init_IIC init code */
  /* IICC2: GCAEN=0,ADEXT=0,AD10=0,AD9=0,AD8=0 */
  IICC2 = 0x00;                                      
  /* IICF: MULT1=0,MULT0=1,ICR5=0,ICR4=0,ICR3=0,ICR2=0,ICR1=0,ICR0=0 */
  IICF = 0x40;                                      
  /* IICA: AD7=1,AD6=0,AD5=1,AD4=0,AD3=0,AD2=0,AD1=0 */
  IICA = 0xA0;                                      
  /* IICS: TCF=0,IAAS=0,BUSY=0,ARBL=1,SRW=0,IICIF=1,RXAK=0 */
  IICS = 0x12;                         /* Clear the interrupt flags */
  /* IICC1: IICEN=1 */
  IICC1 |= (unsigned char)0x80;                               
  /* IICC1: IICEN=1,IICIE=1,MST=0,TX=0,TXAK=0,RSTA=0 */
  IICC1 = 0xC0;                                      
  /* ### Init_GPIO init code */
  /* PTBD: PTBD7=0 */
  PTBD &= (unsigned char)~0x80;                     
  /* PTBPE: PTBPE7=0 */
  PTBPE &= (unsigned char)~0x80;                     
  /* PTBDD: PTBDD7=1 */
  PTBDD |= (unsigned char)0x80;                               
  /* ### Init_KBI init code */
  /* KBISC: KBIE=0 */
  KBISC &= (unsigned char)~0x02;                     
  /* KBIES: KBEDG7=0,KBEDG6=0,KBEDG5=0,KBEDG4=0,KBEDG3=0,KBEDG2=0,KBEDG1=0,KBEDG0=0 */
  KBIES = 0x00;                                      
  /* KBISC: KBIMOD=0 */
  KBISC &= (unsigned char)~0x01;                     
  /* KBIPE: KBIPE7=0,KBIPE6=0,KBIPE5=0,KBIPE4=1,KBIPE3=0,KBIPE2=0,KBIPE1=1,KBIPE0=0 */
  KBIPE = 0x12;                                      
  /* KBISC: KBACK=1 */
  KBISC |= (unsigned char)0x04;                               
  /* KBISC: KBIE=1 */
  KBISC |= (unsigned char)0x02;                               
  /* ### */
  asm CLI;                             /* Enable interrupts */
} /*MCU_init*/


/* Initialization of the CPU registers in FLASH */

/* NVPROT: FPS7=1,FPS6=1,FPS5=1,FPS4=1,FPS3=1,FPS2=1,FPS1=1,FPDIS=1 */
const unsigned char NVPROT_INIT @0x0000FFBD = 0xFF;

/* NVOPT: KEYEN=0,FNORED=1,SEC01=1,SEC00=0 */
const unsigned char NVOPT_INIT @0x0000FFBF = 0x7E;





/* END MCUinit */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.01 [03.92]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
